@extends('layouts.dashboard')

@section('title', 'Atribusi - Selinku')

@section('content')
<div class="max-w-2xl mx-auto space-y-6">
    <div>
        <h2 class="text-2xl font-bold text-slate-900">Atribusi</h2>
        <p class="text-slate-500 mt-1">Tentang pengembang aplikasi ini.</p>
    </div>

    <div class="bg-white rounded-xl shadow-sm border border-slate-200 p-8 text-center">
        <div class="w-20 h-20 bg-emerald-100 rounded-full flex items-center justify-center mx-auto mb-6 text-emerald-600">
            <i class="fa-solid fa-heart text-3xl"></i>
        </div>
        
        <h3 class="text-xl font-bold text-slate-900 mb-4">Terima Kasih!</h3>
        
        <p class="text-slate-600 mb-6 leading-relaxed">
            Terima kasih telah membeli dan menggunakan projek ini dari <a href="https://perprojek.com" target="_blank" class="text-emerald-600 font-medium hover:underline">Perprojek.com</a>.
        </p>

        <div class="bg-slate-50 p-6 rounded-lg border border-slate-100 mb-8">
            <p class="text-slate-800 font-medium text-lg mb-2">Selinku</p>
            <p class="text-slate-500">adalah Smart Link Management System yang dipersembahkan oleh <span class="font-semibold text-slate-700">Perprojek.com</span></p>
        </div>

        <a href="https://perprojek.com" target="_blank" class="inline-flex items-center gap-2 px-6 py-3 bg-emerald-600 text-white rounded-lg hover:bg-emerald-700 transition-colors font-medium">
            <i class="fa-solid fa-globe"></i>
            Kunjungi Website Kami
        </a>
    </div>
</div>
@endsection
