<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Click extends Model
{
    protected $fillable = [
        'shortlink_id',
        'ip_address',
        'user_agent',
        'referer_url',
        'country',
        'city',
        'device_type',
        'browser',
        'os',
        'is_unique',
        'clicked_at',
    ];

    protected $casts = [
        'is_unique' => 'boolean',
        'clicked_at' => 'datetime',
    ];

    // Relationships
    public function shortlink()
    {
        return $this->belongsTo(Shortlink::class);
    }
}
